% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_smi.R
\name{smi}
\alias{smi}
\title{Chart the Stochastic Momentum Index (SMI)}
\usage{
smi(
 nFastK = 14,
 nFastD = 3,
 nSlowD = 3,
 maType,
 bounded = TRUE,
 smooth = 1,
 upper_limit = 40,
 lower_limit = -40,
 color = "#4682b4",
 ...
)
}
\arguments{
\item{nFastK}{Number of periods for fast \%K (i.e. the number of past periods
to use).}

\item{nFastD}{Number of periods for fast \%D (i.e. the number smoothing
periods to apply to fast \%K).}

\item{nSlowD}{Number of periods for slow \%D (i.e. the number smoothing
periods to apply to fast \%D).}

\item{maType}{Either:
\enumerate{
  \item A function or a string naming the function to be called.
  \item A \emph{list} with the first component like (1) above, and
    additional parameters specified as \emph{named} components.
    See Examples.
}}

\item{bounded}{Logical, should current period's values be used in the
calculation?}

\item{smooth}{Number of internal smoothing periods to be applied before
calculating FastK. See Details.}

\item{upper_limit}{A \link{numeric}-vector of \link{length} 1. 40 by default.
Sets the upper limit of the \link[TTR:stochastics]{TTR::SMI}.}

\item{lower_limit}{A \link{numeric}-vector of \link{length} 1. -40 by default.
Sets the lower limit of the \link[TTR:stochastics]{TTR::SMI}.}

\item{color}{A \link{character}-vector of \link{length} 1. "#4682b4" by default.}

\item{...}{For internal use. Please ignore.}
}
\value{
An \link{invisible} \code{\link[plotly:plot_ly]{plotly::plot_ly()}}-object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A high-level \code{\link[plotly:plot_ly]{plotly::plot_ly()}}- and \code{\link[plotly:add_trace]{plotly::add_lines()}}-function that
interacts with the \code{\link[TTR:stochastics]{TTR::SMI()}}-function.
The function adds a subchart with a \code{\link[TTR:stochastics]{TTR::SMI()}}-indicator.
}
\examples{
# script start;

# 1) charting weekly
# BTC using candlesticks
# and indicators
cryptoQuotes::chart(
  ticker = BTC,
  main = cryptoQuotes::kline(),
  sub = list(
    cryptoQuotes::volume(),
    cryptoQuotes::macd()
  ),
  indicator = list(
    cryptoQuotes::bollinger_bands(),
    cryptoQuotes::sma(),
    cryptoQuotes::alma()
  ),
  options = list(
    dark = TRUE,
    deficiency = FALSE
  )
)

# script end;
}
\seealso{
Other chart indicators: 
\code{\link{add_event}()},
\code{\link{alma}()},
\code{\link{bollinger_bands}()},
\code{\link{chart}()},
\code{\link{dema}()},
\code{\link{donchian_channel}()},
\code{\link{ema}()},
\code{\link{evwma}()},
\code{\link{fgi}()},
\code{\link{hma}()},
\code{\link{lsr}()},
\code{\link{macd}()},
\code{\link{rsi}()},
\code{\link{sma}()},
\code{\link{volume}()},
\code{\link{vwap}()},
\code{\link{wma}()},
\code{\link{zlema}()}

Other subchart indicators: 
\code{\link{add_event}()},
\code{\link{fgi}()},
\code{\link{lsr}()},
\code{\link{macd}()},
\code{\link{rsi}()},
\code{\link{volume}()}

Other momentum indicators: 
\code{\link{macd}()},
\code{\link{rsi}()}
}
\author{
Serkan Korkmaz
}
\concept{chart indicators}
\concept{momentum indicators}
\concept{subchart indicators}
