% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cto_form_attachment.R
\name{cto_form_attachment}
\alias{cto_form_attachment}
\title{Download Attachments from a SurveyCTO Form}
\usage{
cto_form_attachment(form_id, filename = NULL, dir = getwd(), overwrite = FALSE)
}
\arguments{
\item{form_id}{A string specifying the SurveyCTO form ID.}

\item{filename}{Optional character vector of specific filenames to download
(e.g., \code{"prices.csv"}). If \code{NULL} (default), all available attachments
associated with the form are downloaded.}

\item{dir}{A string giving the directory where files will be saved.
Defaults to \code{\link[=getwd]{getwd()}}.}

\item{overwrite}{Logical; if \code{TRUE}, existing files in \code{dir} will be
overwritten. If \code{FALSE} (the default), existing files are skipped.}
}
\value{
A character vector of file paths to all available attachments that exist
locally after the function completes (invisibly).

Returns \code{invisible(NULL)} if the form has no attachments.
}
\description{
Downloads files attached to a deployed SurveyCTO form, such as preloaded
CSV files, media assets, or other server-side attachments.
}
\details{
This function first calls \code{\link[=cto_form_metadata]{cto_form_metadata()}} to retrieve metadata for
the deployed form, including the list of available attachments.
\itemize{
\item \strong{File types}: Any attached file type can be downloaded (for example,
images, audio, or CSV files).
\item \strong{Progress reporting}: When \code{options(scto.verbose = TRUE)} (default),
progress messages are printed using the CLI framework.
\item \strong{Caching}: Files are not re-downloaded if they already exist in \code{dir}
unless \code{overwrite = TRUE}.
}

If all requested files are not available, the function aborts with
an informative message suggesting how to inspect the form metadata.
}
\examples{
\dontrun{
files <- cto_form_attachment("household_survey")

# 2. Download specific files to a local directory
cto_form_attachment(
  form_id  = "household_survey",
  filename = c("item_list.csv", "logo.png"),
  dir      = "data/raw"
)

# 3. Force re-download of a file
p <- cto_form_attachment(
  form_id  = "household_survey",
  filename = "prices.csv",
  overwrite = TRUE
)

prices <- read.csv(p)
}
}
\seealso{
Other Form Management Functions: 
\code{\link{cto_form_data}()},
\code{\link{cto_form_data_attachment}()},
\code{\link{cto_form_dofile}()},
\code{\link{cto_form_languages}()},
\code{\link{cto_form_metadata}()}
}
\concept{Form Management Functions}
