% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sample.curves}
\alias{sample.curves}
\title{Sample points on curves}
\usage{
sample.curves(curves, ptsPerCurve = as.integer(c(500)), randomPoints = TRUE)
}
\arguments{
\item{curves}{A list where each element is a function being a list
containing a matrix \code{coords} (curves' values, d columns).}

\item{ptsPerCurve}{A vector of numbers of points to be sampled on each
curve. If \code{length(ptsPerCurve) < length(curves)} then the first entry
of \code{ptsPerCurve} is considered only, and corresponds to the number of
points on a curve.}

\item{randomPoints}{A logical, which indicates whether the points on the 
curves should be drawn from the uniform distribution (on their length) (TRUE, 
default) or as an equidistant (on their length) non-random grid (FALSE).}
}
\value{
A list of curves with each entry being a list constiting of [[1]]
the drawn curve being a matrix named \code{coords}, [[2]] length of the
curve as in \code{curves} named \code{length.init}, and [[3]] length of the
drawn curve named \code{length}.
}
\description{
Samples points uniformly on curves interpolated as linear consequent
segments.
}
\examples{
library(curveDepth)
# Load digits and transform them to curves
data("mnistShort017")
n <- 10 # cardinality of each class
m <- 50 # number of points to sample
cst <- 1/10 # a threshold constant
alp <- 1/8 # a threshold constant
curves0 <- images2curves(mnistShort017$`0`[, , 1:n])
curves1 <- images2curves(mnistShort017$`1`[, , 1:n])
set.seed(1)
curves0Smpl <- sample.curves(curves0, 2 * m)
curves1Smpl <- sample.curves(curves1, 2 * m)
# Calculate depths
depthSpace = matrix(NA, nrow = n * 2, ncol = 2)
depthSpace[, 1] = depth.curve.Tukey(
  c(curves0Smpl, curves1Smpl), curves0Smpl,
  exactEst = TRUE, minMassObj = cst/m^alp)
depthSpace[, 2] = depth.curve.Tukey(
  c(curves0Smpl, curves1Smpl), curves1Smpl,
  exactEst = TRUE, minMassObj = cst/m^alp)
# Draw the DD-plot
plot(NULL, xlim = c(0, 1), ylim = c(0, 1),
     xlab = paste("Depth w.r.t. '0'"),
     ylab = paste("Depth w.r.t. '1'"),
     main = paste("DD-plot for '0' vs '1'"))
grid()
# Draw the separating rule
dat1 <- data.frame(cbind(
  depthSpace, c(rep(0, n), rep(1, n))))
ddalpha1 <- ddalpha.train(X3 ~ X1 + X2, data = dat1,
                          depth = "ddplot",
                          separator = "alpha")
ddnormal <- ddalpha1$classifiers[[1]]$hyperplane[2:3]
pts <- matrix(c(0, 0, 1, ddnormal[1] / -ddnormal[2]),
              nrow = 2, byrow = TRUE)
lines(pts, lwd = 2)
# Draw the points
points(depthSpace[1:n, ],
       col = "red", lwd = 2, pch = 1)
points(depthSpace[(n + 1):(2 * n), ],
       col = "blue", lwd = 2, pch = 3)
}
\references{
Lafaye De Micheaux, P., Mozharovskyi, P. and Vimond, M. (2018).
Depth for curve data and applications.
}
