% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/in_format.R
\name{in_format}
\alias{in_format}
\title{Define output format for rmarkdown files}
\usage{
in_format(x)
}
\arguments{
\item{x}{A numeric, non-decimal value to represent output format: 3 for "pdf_document", 33 for "html_document", and any other integer for "word_document".}
}
\value{
The rmarkdown::render function called with the interpreted output format from x
}
\description{
Defines the output format for rmarkdown's render function using integer representations:
\itemize{
\item \code{in_format(3)} for "pdf_document"
\item \code{in_format(33)} for "html_document"
\item Any other integer for "word_document" (e.g., \code{in_format(333)}, \code{in_format(4)})
}

Such a function becomes very handy when rmarkdown files share the same frontmatter
through an _output.yaml file. Refer to project's GitHub page for more information \url{https://github.com/mmartinezluis/customknitrender}.
}
\examples{
x <- 3
in_format(3)

x <- 33
in_format(x)
}
