% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rts.R
\name{rts}
\alias{rts}
\title{Returns to scale}
\usage{
rts(deamodel,
           thr = 1e-4)
}
\arguments{
\item{deamodel}{Object of class \code{dea} obtained with some of the DEA model functions.}

\item{thr}{Threshold for the tolerance for considering something equal to 1.
Defaults to 1e-4.}
}
\value{
A dataframe with some information about returns to scale (rts),
depending on the model.
}
\description{
Extract the returns to scale.
}
\examples{
data("Coll_Blasco_2006")
data_example <- make_deadata(Coll_Blasco_2006,
                             ni = 2, 
                             no = 2)
result <- model_basic(data_example, 
                      orientation = "io", 
                      rts ="crs")
rts(result)
 
}
\author{
\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

\strong{Vicente Bolós} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benítez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

University of Valencia (Spain)
}
