% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/casting.R
\name{list-lsd}
\alias{list-lsd}
\alias{deb_as_list}
\alias{deb_as_list.default}
\alias{deb_as_list.deb_lsd}
\alias{deb_as_list.deb_tetra}
\title{Cast \code{deb_lsd} or \code{deb_tetra} to a list of values}
\usage{
deb_as_list(x, ...)

\method{deb_as_list}{default}(x, ...)

\method{deb_as_list}{deb_lsd}(x, ...)

\method{deb_as_list}{deb_tetra}(x, ...)
}
\arguments{
\item{x}{A \code{deb_lsd} or \code{deb_tetra} vector to cast to a list of values.}

\item{...}{Arguments passed on to further methods.}
}
\value{
A list of numeric vectors of length 3 or 4, corresponding to lsd
or tetra values.
}
\description{
Cast a \code{deb_lsd} or \code{deb_tetra} vector to a list of numeric vectors either
three or four values per list item corresponding to lsd or tetra values.
}
\details{
\code{deb_as_list()} turns a \code{deb_lsd} or \code{deb_tetra} vector into a list of
numeric vectors of length 3 or 4. It is the inverse of \code{deb_as_lsd()} and
\code{deb_as_tetra()}. Compare to \code{as.list()}, which creates a list of \code{deb_lsd}
or \code{deb_tetra} vectors or \code{unclass()}, which creates a list of length 3 or
4 with numeric vectors corresponding to the units.
}
\examples{

# deb_lsd vector
x <- deb_lsd(l = 0:3, s = 4:7, d = 8:11)

deb_as_list(x)

# deb_tetra vector

y <- deb_tetra(l = 0:3, s = 4:7, d = 8:11, f = 1:4)

deb_as_list(y)

# This is the inverse of `deb_as_lsd()` of a list of lsd values
z <- deb_as_list(x)

identical(x, deb_as_lsd(z))

}
\seealso{
\code{\link[=deb_as_lsd]{deb_as_lsd()}} and \code{\link[=deb_as_tetra]{deb_as_tetra()}} for the inverse of
\code{deb_as_list()}.
}
