% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dec_shannon.R
\name{dec_shannon}
\alias{dec_shannon}
\title{Shannon diversity decomposition}
\usage{
dec_shannon(x, groups)
}
\arguments{
\item{x}{Vector of dimension S (spicies) with the numbers of observed individuals in each spicy. NA values are allowed. 0 values are converted to NA.}

\item{groups}{Vector of dimension S of factors indicating the groups.}
}
\value{
\itemize{
  \item \code{shannon}: Shannon's total Entropy.
  \item \code{within}: Within groups entropy.
  \item \code{between}: Between groups entropy.
  \item \code{groups}: A data frame with information about each group: relative frequency, internal entropy and number of spicies.
}
}
\description{
Computes Shannon diversity and its decomposition
}
\examples{
data(Qesem_s)
dec_shannon(Qesem_s$HU, Qesem_s$Group)

}
\references{
"Arnaud Barat, Andreu Sansó, Maite Arilla-Osuna, Ruth Blasco, Iñaki Pérez-Fernández, Gabriel Cifuentes-Alcobenda, Rubén Llorente, Daniel Vivar-Ríos, Ella Assaf, Ran Barkai, Avi Gopher, & Jordi Rosell-Ardèvol (2025): Quantifying Diversity through Entropy Decomposition. Insights into Hominin Occupation and Carcass Processing  at Qesem cave"
}
\seealso{
\link{shannon}
}
