% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AE.R
\name{binary_thresh_attribute}
\alias{binary_thresh_attribute}
\title{Separable algorithm for threshold attributable effect in a sensitivity
analysis with at most one over-exposed unit in each matched set.
For a greater than alternative, finds the 'a' matched sets that
most decrease the mean and/or variance.}
\usage{
binary_thresh_attribute(
  Z,
  Q,
  index,
  gamma,
  thresh = 0,
  a = 1,
  trans = identity,
  mc = 50000
)
}
\arguments{
\item{Z}{A length N vector of (nonnegative) observed doses.}

\item{Q}{A length N vector of observed binary outcomes.}

\item{index}{A length N vector of indices indicating matched set membership.}

\item{gamma}{The nonnegative sensitivity parameter; gamma = 0 means no
unmeasured confounding.}

\item{thresh}{The dose threshold for the TAE.}

\item{a}{The number of attributable effects to test for.}

\item{trans}{The transformation of the doses to use for the test statistic.
Default is the identity function.}

\item{mc}{Number of monte-carlo samples if testing the sharp null, i.e. a = 0.}
}
\value{
Either "reject" if the value a is deemed
not plausible/compatible, "feasible" if the value a is deemed so,
else a list containing a p-value and dataframe of
matched sets that have contribution to the test statistic
sorted in order of smallest mean reduction followed by
smallest variance reduction.
}
\description{
Separable algorithm for threshold attributable effect in a sensitivity
analysis with at most one over-exposed unit in each matched set.
For a greater than alternative, finds the 'a' matched sets that
most decrease the mean and/or variance.
}
\examples{
# Load the data
data <- lead_crime
# Solve by the separable algorithm
solution <- binary_thresh_attribute(data$log_lead, data$complain, data$matched_sets,
gamma = 0, thresh = log(3.5), a = 5, trans = identity)

}
