% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_helpers.R
\name{var_est}
\alias{var_est}
\title{A function for variance estimation}
\usage{
var_est(y, W, H_Q)
}
\arguments{
\item{y}{a vector of length I containing the value of test statistics from
each matched set}

\item{W}{weight vector of length I.}

\item{H_Q}{hat matrix corresponding to a matrix Q with dimension I by L.}
}
\value{
a conservative estimate of the standard deviation of the test statistic.
}
\description{
A function for variance estimation
}
\examples{
test_stat <- c(1, 2, 1.5)
weight <- rep(1, 3)
Q <- matrix(1:9, nrow = 3, ncol = 2)
hat <- Q \%*\% solve(t(Q) \%*\% Q) \%*\% t(Q)
}
