% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddbs_combine.R
\name{ddbs_combine}
\alias{ddbs_combine}
\title{Combine geometries into a single MULTI-geometry}
\usage{
ddbs_combine(
  x,
  conn = NULL,
  name = NULL,
  crs = NULL,
  crs_column = "crs_duckspatial",
  overwrite = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{x}{An \code{sf} spatial object. Alternatively, it can be a string with the
name of a table with geometry column within the DuckDB database \code{conn}.
Data is returned from this object.}

\item{conn}{A connection object to a DuckDB database. If \code{NULL}, the function
runs on a temporary DuckDB database.}

\item{name}{A character string of length one specifying the name of the table,
or a character string of length two specifying the schema and table
names. If \code{NULL} (the default), the function returns the result as an
\code{sf} object}

\item{crs}{The coordinates reference system of the data. Specify if the data
doesn't have a \code{crs_column}, and you know the CRS.}

\item{crs_column}{character string specifying the name of the CRS column.
Default is \code{"crs_duckspatial"}}

\item{overwrite}{Boolean. whether to overwrite the existing table if it exists. Defaults
to \code{FALSE}. This argument is ignored when \code{name} is \code{NULL}.}

\item{quiet}{A logical value. If \code{TRUE}, suppresses any informational messages.
Defaults to \code{FALSE}.}
}
\value{
an \code{sf} object or \code{TRUE} (invisibly) for table creation
}
\description{
Combines all geometries from a \code{sf} object or a DuckDB table into a single
MULTI-geometry using the spatial extension. This is equivalent to
\code{sf::st_combine()}. Returns the result as an \code{sf} object or creates
a new table in the database.
}
\examples{
\dontrun{
# load packages
library(duckspatial)
library(sf)

# create a duckdb database in memory (with spatial extension)
conn <- ddbs_create_conn(dbdir = "memory")

# read data
countries_sf <- st_read(system.file("spatial/countries.geojson", package = "duckspatial"))

# store in duckdb
ddbs_write_vector(conn, countries_sf, "countries")

# combine all geometries into one
ddbs_combine(conn = conn, "countries")

# combine without using a connection
ddbs_combine(countries_sf)

# store result in a new table
ddbs_combine(conn = conn, "countries", name = "countries_combined")
}
}
