% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddbs_extension.R
\name{ddbs_load}
\alias{ddbs_load}
\title{Loads the Spatial extension}
\usage{
ddbs_load(conn, quiet = FALSE)
}
\arguments{
\item{conn}{A connection object to a DuckDB database}

\item{quiet}{A logical value. If \code{TRUE}, suppresses any informational messages.
Defaults to \code{FALSE}.}
}
\value{
TRUE (invisibly) for successful installation
}
\description{
Checks if a spatial extension is installed, and loads it in a DuckDB database
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
## load packages
library(duckspatial)
library(duckdb)

## connect to in memory database
conn <- duckdb::dbConnect(duckdb::duckdb())

## install the spatial exntesion
ddbs_install(conn)
ddbs_load(conn)

## disconnect from db
duckdb::dbDisconnect(conn)
\dontshow{\}) # examplesIf}
}
