% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_encircle.R
\name{geom_encircle}
\alias{geom_encircle}
\title{Automatically enclose points in a polygon}
\usage{
geom_encircle(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{mapping}

\item{data}{data}

\item{stat}{stat}

\item{position}{position}

\item{na.rm}{na.rm}

\item{show.legend}{show.legend}

\item{inherit.aes}{inherit.aes}

\item{...}{dots}
}
\value{
adds a circle around the specified points
}
\description{
Automatically enclose points in a polygon
}
\details{
\if{html}{
A sample of the output from \code{geom_encircle()}

}
\if{latex}{
A sample of the output from \code{geom_encircle()}

}
}
\examples{
d <- data.frame(x=c(1,1,2),y=c(1,2,2)*100)

gg <- ggplot2::ggplot(d,ggplot2::aes(x,y))
gg <- gg + ggplot2::scale_x_continuous(expand=c(0.5,1))
gg <- gg + ggplot2::scale_y_continuous(expand=c(0.5,1))

gg + geom_encircle(s_shape=1, expand=0) + ggplot2::geom_point()

gg + geom_encircle(s_shape=1, expand=0.1, colour="red") + ggplot2::geom_point()

gg + geom_encircle(s_shape=0.5, expand=0.1, colour="purple") + ggplot2::geom_point()

gg + geom_encircle(data=subset(d, x==1), colour="blue", spread=0.02) +
  ggplot2::geom_point()

gg +geom_encircle(data=subset(d, x==2), colour="cyan", spread=0.04) +
  ggplot2::geom_point()

gg <- ggplot2::ggplot(ggplot2::mpg, ggplot2::aes(displ, hwy))
gg + geom_encircle(data=subset(ggplot2::mpg, hwy>40)) + ggplot2::geom_point()
gg + geom_encircle(ggplot2::aes(group=manufacturer)) + ggplot2::geom_point()
gg + geom_encircle(ggplot2::aes(group=manufacturer,fill=manufacturer),alpha=0.4)+
       ggplot2::geom_point()
gg + geom_encircle(ggplot2::aes(group=manufacturer,colour=manufacturer))+
       ggplot2::geom_point()

ss <- subset(ggplot2::mpg,hwy>31 & displ<2)

gg + geom_encircle(data=ss, colour="blue", s_shape=0.9, expand=0.07) +
  ggplot2::geom_point() + ggplot2::geom_point(data=ss, colour="blue")
}
\author{
Ben Bolker
}
