% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/energy_ratios.R
\name{energy_burden_func}
\alias{energy_burden_func}
\title{Calculate Energy Burden}
\usage{
energy_burden_func(g, s, se = NULL)
}
\arguments{
\item{g}{Numeric vector of gross income values}

\item{s}{Numeric vector of energy spending values}

\item{se}{Optional numeric vector of effective energy spending (defaults to s)}
}
\value{
Numeric vector of energy burden values (ratio of spending to income)
}
\description{
Calculates the energy burden as the ratio of energy spending to gross income.
Energy burden is defined as E_b = S/G, where S is energy spending and G is
gross income.
}
\examples{
# Calculate energy burden for households
gross_income <- c(50000, 75000, 100000)
energy_spending <- c(3000, 3500, 4000)
energy_burden_func(gross_income, energy_spending)
}
