% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leer.inei.R
\name{leer.inei}
\alias{leer.inei}
\title{Leer bases de la ENAHO}
\usage{
leer.inei(
  encuesta = "ENAHO",
  modulo,
  periodos,
  directorio = getwd(),
  tipo = "anual",
  columnas = NULL,
  solocomunes = FALSE,
  ensilencio = FALSE,
  combinar = FALSE,
  combinarsolocomunes = FALSE
)
}
\arguments{
\item{encuesta}{el nombre de una encuesta del INEI. Las opciones dispobibles son
\code{"ENAHO"}, \code{"ENAHOpanel"} y \code{"ENDES"}. No importa si está escrito en mayúscula o minúscula.}

\item{modulo}{el código del módulo deseado.}

\item{periodos}{los años deseados.}

\item{directorio}{el directorio de donde están las carpetas generadas por \code{\link{descargar.inei}}.}

\item{tipo}{el tipo de período deseado. Las opciones son \code{"anual"},
  \code{"t1"} (primer trimestre),
  \code{"t2"} (segundo trimestre),
  \code{"t3"} (tercer trimestre),
y \code{"t4"} (cuarto trimestre). Las opciones pueden combinarse.}

\item{columnas}{una cadena de texto que indica qué columnas seleccionar.}

\item{solocomunes}{un valor lógico que indica si sólo deben leerse las columnas comunes.}

\item{ensilencio}{un valor lógico que indica si el progreso de la función debe ser omitido.}

\item{combinar}{un valor lógico que indica si las bases deben ser combinadas en un único data frame.}

\item{combinarsolocomunes}{un valor lógico que indica si sólo deben combinarse las columnas comunes.}
}
\value{
un data frame o una lista.
}
\description{
Lee bases de la ENAHO descargadas con \code{\link{descargar.inei}}. Si más de una base es leída,
se carga una lista, cuyos elementos son cada una de las bases.
En caso que el INEI provea más de una base por módulo y período se leerá la base
con mayor peso.
}
\examples{
directorio = system.file("extdata", package = "enaho")
leer.inei(modulo = 37, periodos = 2011, directorio = directorio, tipo = "t1")

}
