% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{combine_date_time_cols}
\alias{combine_date_time_cols}
\title{Combine date and time columns into a single DateTime column}
\usage{
combine_date_time_cols(.data, tz = NULL)
}
\arguments{
\item{.data}{(data.frame) A data frame or data frame extension (e.g. a tibble)}

\item{tz}{(character) a time zone name (default: time zone of the POSIXt
object x)}
}
\value{
(data.frame) An object of the same type as \code{.data}
}
\description{
Combine date and time columns into a single DateTime column
}
\examples{
df <- data.frame(
  date_a = as.Date(c("2020-01-01", "2020-01-02")),
  date_b = as.POSIXct(c("2020-02-01", "2020-02-02")),
  time_a = as.POSIXct(c("1900-01-01 01:01:01", "1900-01-01 02:02:02")),
  time_b = as.POSIXct(c("1900-01-01 01:01:01", "1900-01-01 02:02:02"))
)

combine_date_time_cols(df)
}
