% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_fit_graph.R
\name{fit_graph}
\alias{fit_graph}
\title{Fit a decomposable graphical model}
\usage{
fit_graph(
  df,
  type = "fwd",
  q = 0.5,
  trace = FALSE,
  sparse_qic = FALSE,
  thres = 5,
  wrap = TRUE
)
}
\arguments{
\item{df}{Character data.frame}

\item{type}{Character ("fwd", "bwd", "tree" or "tfwd")}

\item{q}{Penalty term in the stopping criterion
where \code{0} = AIC and \code{1} = BIC. Anything in between is
referred to as \code{qic}}

\item{trace}{Logical indicating whether or not to trace the procedure}

\item{sparse_qic}{Logical. If \code{nrow(df)} is small, the tables
tends to be sparse. In these cases the usual penalty term of AIC and
BIC is often too restrictive. If \code{sparse_qic} is \code{TRUE}
this penality is computed according to a sparse criteria. The criteria
resembles the usual penalty as \code{nrow(df)} grows.}

\item{thres}{A threshold mechanism for choosing between two different ways of
calculating the entropy.}

\item{wrap}{logical specifying if the result of a run with type = "tree"
should be converted to a "fwd" object}
}
\value{
A \code{gengraph} object representing a decomposable graph.
}
\description{
A generic method for structure learning in decomposable
graphical models
}
\details{
The types are
\itemize{
\item "fwd": forward selection
\item "bwd": backward selection
\item "tree": Chow-Liu tree (first order interactions only)
\item "tfwd": A combination of "tree" and "fwd". This can speed up runtime considerably in high dimensions.
}
Using \code{adj_lst} on an object returned by \code{fit_graph} gives the
adjacency list corresponding to the graph. Similarly one can use \code{adj_mat}
to obtain an adjacency matrix. Applying the \code{rip} function on an
adjacency list returns the cliques and separators of the graph.
}
\examples{

g <- fit_graph(derma)
print(g)
plot(g)

# Adjacency matrix and adjacency list
adjm <- adj_mat(g)
adjl <- adj_lst(g)

}
\references{
\url{https://arxiv.org/abs/1301.2267}, \doi{10.1109/ictai.2004.100}
}
\seealso{
\code{\link{adj_lst}}, \code{\link{adj_mat}},
\code{\link{as_igraph}}, \code{\link{gengraph}}
}
