% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gevcTest.R
\name{gevcTest}
\alias{gevcTest}
\title{GEV Classifier - testing}
\usage{
gevcTest(train, test, pre, prob = TRUE, alpha)
}
\arguments{
\item{train}{a data matrix containing the train data. Class labels should not be included.}

\item{test}{a data matrix containing the test data.}

\item{pre}{a numeric vector of parameters obtained with the function \code{\link{gevcTrain}}.}

\item{prob}{logical indicating whether p-values should be returned.}

\item{alpha}{threshold to be used if \code{prob} is equal to \code{FALSE}. It must be between 0 and 1.}
}
\value{
If \code{prob} is equal to \code{TRUE}, a vector containing the p-values for each point is returned. A high p-value results in the classification of the corresponding test data as a known point, since this hypothesis cannot be rejected. If the p-value is small, the corresponding test data is classified as an unknown point. If \code{prob} is equal to \code{TRUE}, a vector of predicted values is returned.
}
\description{
This function is used to evaluate a test set for a pre-trained GEV classifier. It can be used to perform open set classification based on the generalized Pareto distribution.
}
\details{
For details on the method and parameters see Vignotto and Engelke (2018).
}
\examples{
trainset <- LETTER[1:15000,]
testset <- LETTER[-(1:15000), -1]
knowns <- trainset[trainset$class==1, -1]
gevClassifier <- gevcTrain(train = knowns)
predicted <- gevcTest(train = knowns, test = testset, pre = gevClassifier)
}
\references{
Vignotto, E., & Engelke, S. (2018). Extreme Value Theory for Open Set Classification-GPD and GEV Classifiers. \emph{arXiv preprint arXiv:1808.09902}.
}
\seealso{
\code{\link{gevcTrain}}
}
\author{
Edoardo Vignotto \cr
\email{edoardo.vignotto@unige.ch}
}
