% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{qr_lm}
\alias{qr_lm}
\title{Ordinary least squares for the linear regression model}
\usage{
qr_lm(y, X, X_test = NULL)
}
\arguments{
\item{y}{a vector of length-\eqn{n} response vector.}

\item{X}{an \eqn{(n\times p)} full column rank matrix of predictors.}

\item{X_test}{an \eqn{(q\times p)} full column rank matrix. Test set. By default it set to NULL.}
}
\value{
A named list containing \describe{
\item{coeff}{a length-\eqn{p} vector containing the solution for the parameters \eqn{\beta}.}
\item{coeff.se}{a length-\eqn{p} vector containing the standard errors for the estimated regression parameters \eqn{\beta}.}
\item{fitted}{a length-\eqn{n} vector of fitted values, \eqn{\widehat{y}=X\widehat{\beta}}.}
\item{residuals}{a length-\eqn{n} vector of residuals, \eqn{\varepsilon=y-\widehat{y}}.}
\item{residuals_norm2}{the squared L2-norm of the residuals, \eqn{\Vert\varepsilon\Vert_2^2.}}
\item{y_norm2}{the squared L2-norm of the response variable, \eqn{\Vert y\Vert_2^2.}}
\item{R}{the \eqn{R\in\mathbb{R}^{p\times p}} upper triangular matrix of the QR decomposition.}
\item{L}{the inverse of the \eqn{R\in\mathbb{R}^{p\times p}} upper triangular matrix of the QR decomposition \eqn{L = R^{-1}}.}
\item{XTX}{the Gram matrix \eqn{X^\top X\in\mathbb{R}^{p\times p}} of the least squares problem.}
\item{XTX_INV}{the inverse of the Gram matrix \eqn{X^\top X\in\mathbb{R}^{p\times p}} of the least squares problem \eqn{(X^\top X)^{-1}}.}
\item{XTy}{A vector equal to \eqn{X^\top y}, the cross-product of the design matrix \eqn{X} with the response vector \eqn{y}.}
\item{sigma2_hat}{An estimate of the error variance \eqn{\sigma^2}, computed as the residual sum of squares divided by the residual degrees of freedom \eqn{\widehat{\sigma}^2 = \frac{\|y - X\hat{\beta}\|_2^2}{df}}}
\item{df}{The residual degrees of freedom, given by \eqn{n - p}, where \eqn{n} is the number of observations and \eqn{p} is the number of estimated parameters.}
\item{R2}{\eqn{R^2}, coefficient of determination, measure of goodness-of-fit of the model.}
\item{predicted}{predicted values for the test set, \eqn{X_{\text{test}}\widehat{\beta}}. It is only available if X_test is not NULL.}
}
}
\description{
qr_lm, or LS for linear regression models, solves the following optimization problem
\deqn{\textrm{min}_\beta ~ \frac{1}{2}\|y-X\beta\|_2^2,}
for \eqn{y\in\mathbb{R}^n} and \eqn{X\in\mathbb{R}^{n\times p}} witn \eqn{n>p}, to obtain a coefficient vector \eqn{\widehat{\beta}\in\mathbb{R}^p}. The design matrix \eqn{X\in\mathbb{R}^{n\times p}}
contains the observations for each regressor.
}
\examples{

## generate sample data
## create data: n > p
set.seed(1234)
n    <- 12
n0   <- 3
p    <- 7
X    <- matrix(rnorm(n * p), n, p)
b    <- rep(1, p)
sig2 <- 0.25
y    <- X \%*\% b + sqrt(sig2) * rnorm(n)
summary(lm(y~X))

## test
X_test <- matrix(rnorm(n0 * p), n0, p)

## lm
qr_lm(y = y, X = X, X_test = X_test)
qr_lm(y = y, X = X)

}
