% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{qr_pivot2perm}
\alias{qr_pivot2perm}
\title{Reconstruct the permutation matrix from the pivot vector.}
\usage{
qr_pivot2perm(pivot)
}
\arguments{
\item{pivot}{a vector of dimension \eqn{n} of pivot elements from the QR factorization.}
}
\value{
the perumutation matrix \eqn{P} of dimension \eqn{n \times n}.
}
\description{
returns the permutation matrix for the QR decomposition.
}
\examples{
## generate sample data
set.seed(1234)
n <- 12
p <- 5
X <- matrix(rnorm(n * p), n, p)

## get the full QR decomposition with pivot
qr_res <- fastQR::qr_fast(X = X,
                          tol = sqrt(.Machine$double.eps),
                          pivot = TRUE)

## get the pivot matrix
P <- qr_pivot2perm(qr_res$pivot)

}
\references{
\insertRef{golub_van_loan.2013}{fastQR}

\insertRef{bjorck.2015}{fastQR}

\insertRef{bjorck.2024}{fastQR}

\insertRef{bernardi_etal.2024}{fastQR}
}
