% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastfocal_weights.R
\name{fastfocal_weights}
\alias{fastfocal_weights}
\title{Generate weight matrix for focal operations using map units}
\usage{
fastfocal_weights(x, d, w = "circle", normalize = TRUE, plot = FALSE)
}
\arguments{
\item{x}{SpatRaster (used for resolution; assumes square pixels).}

\item{d}{numeric. Radius in map units for most kernels; \strong{sigma} in map units for "gaussian"/"Gauss".}

\item{w}{character. One of:
"rectangle","circle","circular","gaussian","Gauss","pareto","idw",
"exponential","triangular","cosine","logistic","cauchy","quartic","epanechnikov".}

\item{normalize}{logical. If TRUE (default), scale weights to sum to 1.}

\item{plot}{logical. If TRUE, plots the kernel.}
}
\value{
numeric matrix of weights.
}
\description{
Builds an unnormalized (or normalized) kernel from map units.
Circle uses a center-distance rule (include if center <= d).
\strong{Gaussian interprets d as sigma in map units and truncates at 3 sigma},
matching terra::focalMat(..., type = "Gauss").
}
\examples{
# Small raster (resolution = 1 map unit)
r <- terra::rast(nrows = 5, ncols = 5, xmin = 0, xmax = 5, ymin = 0, ymax = 5)

# Circle: d is a radius in map units -> here cell_radius = 2 -> 5x5 kernel
Kc <- fastfocal_weights(r, d = 2, w = "circle", normalize = TRUE)
dim(Kc)            # 5 x 5
round(sum(Kc), 6)  # ~1

# Gaussian: d is sigma in map units, truncated at 3 sigmas
Kg <- fastfocal_weights(r, d = 1, w = "gaussian", normalize = TRUE)
dim(Kg)            # 7 x 7 (since 2*ceil(3*sigma) + 1)
round(sum(Kg), 6)  # ~1

# \donttest{
# Quick visualization (kept out of CRAN's main run)
fastfocal_weights(r, d = 2, w = "circle", normalize = TRUE, plot = TRUE)
# }
}
