% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastgeojson.R
\name{fastgeojson}
\alias{fastgeojson}
\alias{sf_geojson_str}
\alias{df_json_str}
\title{High-Performance 'GeoJSON' and 'JSON' Serialization}
\usage{
sf_geojson_str(x)

df_json_str(x)
}
\arguments{
\item{x}{An input object (e.g., a data.frame or sf object) to serialize.}
}
\value{
For \code{sf_geojson_str()}, a length-one character vector with class
\code{c("geojson", "json")} containing a 'GeoJSON' FeatureCollection string.
For \code{df_json_str()}, a length-one character vector with class \code{"json"}
containing a 'JSON' array string.
}
\description{
\code{fastgeojson} provides a high-performance serialization backend for converting
common R data structures into 'JSON' strings. The core encoders are implemented
in 'Rust' using the \strong{extendr} framework and are designed to efficiently handle
large spatial and tabular datasets.

The package focuses on two primary use cases:
\itemize{
\item Converting \code{sf} objects into 'GeoJSON' FeatureCollections.
\item Converting rectangular \code{data.frame} objects into 'JSON' arrays.
}

The resulting 'JSON' is returned as a character string with an appropriate
class (\code{"geojson"} / \code{"json"}), allowing it to be passed directly to client-side
'JavaScript' libraries or web frameworks without additional serialization steps.
}
\details{
For sufficiently large inputs, encoding may be performed in parallel using
multiple CPU cores via the 'rayon' library in 'Rust'. Parallel execution is
enabled automatically based on input size and geometry type.

By returning pre-serialized 'JSON' strings, these functions allow frameworks
such as 'Shiny' and 'Plumber' to avoid redundant re-encoding during data
transfer, which can significantly reduce server-side overhead in interactive
or high-throughput applications.
}
\section{Type handling}{

\itemize{
\item \strong{Numeric:} Written as JSON numbers.
\item \strong{Logical:} Written as JSON booleans.
\item \strong{Character:} Written as JSON strings with UTF-8 escaping.
\item \strong{Factor:} Encoded using their character levels.
\item \strong{Missing values:} Missing (\code{NA}) values may be omitted from
output objects to reduce payload size.
\item \strong{Geometries:} Supports common \code{sf} geometry types including
POINT, LINESTRING, POLYGON, and their MULTI variants.
}
}

\examples{
if (requireNamespace("sf", quietly = TRUE)) {
   nc <- sf::st_read(system.file("shape/nc.shp", package = "sf"), quiet = TRUE)
   geo_str <- sf_geojson_str(nc)
}

df <- data.frame(x = runif(10), y = runif(10))
json_str <- df_json_str(df)

}
\seealso{
\code{\link[=sf_geojson_str]{sf_geojson_str()}} for spatial data,
\code{\link[=df_json_str]{df_json_str()}} for tabular data.
}
