% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counterfactual_explain.R
\name{counterfactual_explain}
\alias{counterfactual_explain}
\title{Generate counterfactual explanations for a fastml model}
\usage{
counterfactual_explain(
  object,
  observation,
  variables = NULL,
  data = c("train", "test"),
  positive_class = NULL,
  event_class = NULL,
  label_levels = NULL,
  ...
)
}
\arguments{
\item{object}{A `fastml` object.}

\item{observation}{A single observation (data frame with one row) to compute
counterfactuals for.}

\item{variables}{Optional character vector of candidate variables to vary.
Only numeric variables are used for counterfactual profiling.}

\item{data}{Character string specifying which data to use for the explainer background:
\code{"train"} (default) or \code{"test"}.}

\item{positive_class}{Optional string used to filter lines/points in the
resulting profiles for classification tasks.}

\item{event_class}{Optional event class indicator propagated from
`fastml_prepare_explainer_inputs()` (kept for compatibility).}

\item{label_levels}{Optional vector of label levels propagated from
`fastml_prepare_explainer_inputs()` (kept for compatibility).}

\item{...}{Additional arguments passed to `DALEX::predict_profile`.}
}
\value{
A list (returned invisibly) containing the DALEX profile, filtered
  lines/points when `positive_class` is supplied, and the plotted object if
  rendering succeeds.
}
\description{
Uses DALEX ceteris-paribus profiles (`predict_profile`) to compute
counterfactual-style what-if explanations for a given observation.
}
