% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lwls2D.R
\name{Lwls2D}
\alias{Lwls2D}
\title{Two dimensional local linear kernel smoother.}
\usage{
Lwls2D(
  bw,
  kern = "epan",
  xin,
  yin,
  win = NULL,
  xout1 = NULL,
  xout2 = NULL,
  xout = NULL,
  subset = NULL,
  crosscov = FALSE,
  method = ifelse(kern == "gauss", "plain", "sort2")
)
}
\arguments{
\item{bw}{A scalar or a vector of length 2 specifying the bandwidth.}

\item{kern}{Kernel used: 'gauss', 'rect', 'gausvar', 'epan' (default), 'quar'.}

\item{xin}{An n by 2 data frame or matrix of x-coordinate.}

\item{yin}{A vector of y-coordinate.}

\item{win}{A vector of weights on the observations.}

\item{xout1}{a p1-vector of first output coordinate grid. Defaults to the input gridpoints if left unspecified.}

\item{xout2}{a p2-vector of second output coordinate grid. Defaults to the input gridpoints if left unspecified.}

\item{xout}{alternative to xout1 and xout2. A matrix of p by 2 specifying the output points (may be inefficient if the size of \code{xout} is small).}

\item{subset}{a vector with the indices of x-/y-/w-in to be used (Default: NULL)}

\item{crosscov}{using function for cross-covariance estimation (Default: FALSE). FALSE for auto-covariance estimation and 
TRUE for two-dimensional local linear kernel smoothing or cross-covariance estimation. 
For auto-covariance estimation (i.e., when \code{crosscov} is FALSE), \code{xout1} and \code{xout2} should be the same.}

\item{method}{should one try to sort the values xin and yin before using the lwls smoother? if yes ('sort2' - default for non-Gaussian kernels), if no ('plain' - fully stable; de)}
}
\value{
a p1 by p2 matrix of fitted values if xout is not specified. Otherwise a vector of length p corresponding to the rows of xout.
}
\description{
Two dimensional local weighted least squares smoother. Only local linear smoother for estimating the original curve is available (no higher order, no derivative).
}
