% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_census_data.R
\name{get_census_data}
\alias{get_census_data}
\title{Retrieve American Community Survey data for SVI variables}
\usage{
get_census_data(
  year,
  geography,
  state = NULL,
  county = NULL,
  key = NULL,
  geometry = FALSE,
  exp = FALSE,
  ...
)
}
\arguments{
\item{year}{The year of interest (available 2012-2022).}

\item{geography}{The geography of interest (eg. state, county, zcta, tract)}

\item{state}{(Optional) Specify the state of interest. If data for multiple
states are retrieved together, ranking for SVI calculation will be
performed among all states. \code{state = NULL} as default, or \code{state = 'US'}
return nation-level data.}

\item{county}{(Optional) Specify the county(s) of interest, must be combined
with a value supplied to "state".}

\item{key}{Your Census API key. Obtain one at
\url{https://api.census.gov/data/key_signup.html}. Include it in this argument
or set up your key using \code{tidycensus::census_api_key("YOUR KEY GOES HERE")}.}

\item{geometry}{Default as \code{FALSE} for a regular tibble of census data. If
set as \code{TRUE}, returns a tibble with an additional \code{geometry} column
containing simple feature geometry.}

\item{exp}{Default as \code{FALSE} for retrieving \code{EP_}(percent estimate)
variables directly from ACS when available (as described in CDC/ADSTR SVI
dictionary (https://www.atsdr.cdc.gov/placeandhealth/svi/data_documentation_download.html)).
If set as \code{TRUE}, uses explicitly defined denominators and retrieves the
ACS data to calculate the \code{EP} variables for easier aggregation in
downstream analysis (e.g. \code{get_svi_x()}).}

\item{...}{Other arguments; more details please see \code{\link[tidycensus:get_acs]{tidycensus::get_acs()}}}
}
\value{
A tibble of ACS data with each row represents an enumeration
(geographic) unit and each column represents a census variable ("wide"
form).
}
\description{
This function uses \code{\link[tidycensus:get_acs]{tidycensus::get_acs()}} with a pre-defined
list of variables to retrieves ACS data for SVI calculation. Note that a
Census API key is required for this function to work, which can be obtained
at \url{https://api.census.gov/data/key_signup.html} and set up using
\code{\link[tidycensus:census_api_key]{tidycensus::census_api_key()}}.
}
\examples{
\dontshow{if (Sys.getenv("CENSUS_API_KEY") != "") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Census API key required
 get_census_data(
    year = 2018,
    geography = "county",
    state = "PA"
  )
\dontshow{\}) # examplesIf}
}
