% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_svi_x.R
\name{get_svi_x}
\alias{get_svi_x}
\title{Calculate SVI for communities from census data using customized boundaries}
\usage{
get_svi_x(year, data, xwalk)
}
\arguments{
\item{year}{The year of interest (available 2012-2021), must match the year
specified in retrieving census data.}

\item{data}{The census data retrieved by \code{get_census_data()}.}

\item{xwalk}{A crosswalk (relationship table) between the Census geographic
level and the customized geographic level of interest. A crosswalk between
US counties and commuting zones \code{cty_cz_2020_xwalk} is included as an
example, and please set the column names of the crosswalk as follows:
\describe{
\item{GEOID}{Identifiers for the Census geographic level. Must contain values from \code{GEOID} column in \code{data}, and be in a compatible data type (character).}
\item{GEOID2}{Identifiers (characters or numeric values) for the customized geographic level that is larger geographic than the Census geographic level. The Census geographic level should be nested in the customized geographic level.}
\item{NAME}{An optional column of the names or description of the customized geographic level.}
}}
}
\value{
A tibble of SVI with rows representing the customized geographic
units (with a column name of \code{GEOID}), and columns indicating variable
names (first two columns containing geographic information). For detailed
description of the variable names (column names), please refer to
CDC/ATSDR
documentation.
}
\description{
\code{get_svi_x()} calculates and constructs an SVI table for a
\emph{customized} geographic level of interest based on CDC/ATSDR SVI
documentation (https://www.atsdr.cdc.gov/placeandhealth/svi/data_documentation_download.html).
By supplying a crosswalk (relationship table) between a Census geographic
level and a customized geographic level, census data are summed across the
customized geographic units, and SVI is calculated accordingly to indicate
the relative social vulnerability of the geographic units (communities).
}
\examples{
\dontshow{if (Sys.getenv("CENSUS_API_KEY") != "") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Census API key required
cty2020 <- get_census_data(
    year = 2020,
    geography = "county",
    exp = TRUE
   )

get_svi_x(year = 2020, data = cty2020, xwalk = cty_cz_2020_xwalk)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=get_svi]{get_svi()}} for SVI calculation from census data at a Census
geographic level, and \code{\link[=find_svi]{find_svi()}} for retrieving census data and
calculating SVI for multiple year-state pairs.
}
