% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_narrower_concepts.R
\name{get_narrower_concepts}
\alias{get_narrower_concepts}
\title{Get narrower concepts for a specific concept from the Finto Skosmos API}
\usage{
get_narrower_concepts(vocid, uri, lang = NULL)
}
\arguments{
\item{vocid}{The vocabulary ID, e.g., "yso".}

\item{uri}{The URI of the concept whose narrower concepts to retrieve.}

\item{lang}{The language code for the labels, e.g., "fi" or "en". Optional.}
}
\value{
A tibble containing the narrower concepts (prefLabel and uri) for the specified concept.
}
\description{
Get narrower concepts for a specific concept from the Finto Skosmos API
}
\examples{
narrower_concepts <- get_narrower_concepts(vocid = "yso",
uri = "http://www.yso.fi/onto/yso/p690", lang = "fi")
print(narrower_concepts)
}
