% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix_row_spaces.R
\name{fix_row_spaces}
\alias{fix_row_spaces}
\title{Replace spaces in row names with underscores}
\usage{
fix_row_spaces(df)
}
\arguments{
\item{df}{A data frame}
}
\value{
A modified data frame with spaces in row names replaced by underscores.
}
\description{
This function takes a data frame as an argument and replaces all spaces in
the row names with underscores.
}
\examples{
my_data <- data.frame("Column Name 1" = c(1, 2, 3), "Column Name 2" = c(4, 5, 6))
rownames(my_data) <- c("Row Name 1", "Row Name 2", "Row Name 3")

fix_row_spaces(my_data)
# Returns a data frame with row names where spaces are replaced by underscores.

}
