% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/sampling_frame.R
\name{blocklens}
\alias{blocklens}
\alias{blocklens.sampling_frame}
\title{Get block lengths}
\usage{
blocklens(x, ...)

\method{blocklens}{sampling_frame}(x, ...)
}
\arguments{
\item{x}{Object containing block length information}

\item{...}{Additional arguments passed to methods}
}
\value{
Numeric vector of block lengths
}
\description{
Generic accessor returning the number of scans in each block of a
sampling frame or similar object.
}
\examples{
# Get block lengths from a sampling frame
sframe <- sampling_frame(blocklens = c(100, 120, 80), TR = 2)
blocklens(sframe)
}
