% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hrf.R
\name{hrf_library}
\alias{hrf_library}
\alias{gen_hrf_library}
\title{Generate an HRF library from a parameter grid}
\usage{
hrf_library(fun, pgrid, ...)

gen_hrf_library(...)
}
\arguments{
\item{fun}{A function that generates an HRF, given a set of parameters.}

\item{pgrid}{A data frame where each row is a set of parameters.}

\item{...}{Additional arguments passed to `fun`.}
}
\value{
A combined HRF object representing the library.
}
\description{
`hrf_library` applies a base HRF generating function to each row of a parameter grid.
}
\examples{
# Create library of gamma HRFs with varying parameters
param_grid <- expand.grid(
  shape = c(6, 8, 10),
  rate = c(0.9, 1, 1.1)
)
gamma_library <- hrf_library(
  function(shape, rate) as_hrf(hrf_gamma, params = list(shape = shape, rate = rate)),
  param_grid
)

# Create library with fixed and varying parameters
param_grid2 <- expand.grid(lag = c(0, 2, 4))
lagged_library <- hrf_library(
  function(lag) gen_hrf(HRF_SPMG1, lag = lag),
  param_grid2
)
}
\keyword{internal}
