% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_read.R
\name{data_info}
\alias{data_info}
\title{Get data specification from config}
\usage{
data_info(path)
}
\arguments{
\item{path}{Dot notation path (e.g. "source.private.example"), relative path,
or absolute path to a data file}
}
\value{
A list with data specification including:
\itemize{
\item \code{path} - Full file path
\item \code{type} - File type (csv, rds, stata, spss, sas, etc.)
\item \code{delimiter} - Delimiter for CSV files (comma, tab, etc.)
\item \code{locked} - Whether file is locked for integrity checking
\item \code{private} - Whether file is in private data directory
\item \code{description} - Optional description of the dataset (displayed when loading)
}
}
\description{
Gets the data specification for a given dot notation path from settings.yml.
Supports dot notation (e.g., "source.private.example"), relative paths, and
absolute paths. Auto-detects file type from extension and applies intelligent
defaults for common formats.
}
\examples{
\donttest{
if (FALSE) {
# Get info from dot notation
info <- data_info("source.private.my_data")

# Get info from file path
info <- data_info("data/public/example.csv")
}
}

}
