% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco-bulk-download.R
\encoding{UTF-8}
\name{gisco_bulk_download}
\alias{gisco_bulk_download}
\title{GISCO API bulk download}
\source{
\url{https://gisco-services.ec.europa.eu/distribution/v2/}.
}
\usage{
gisco_bulk_download(
  id = c("countries", "coastal_lines", "communes", "lau", "nuts", "urban_audit",
    "postal_codes"),
  year = 2016,
  cache_dir = NULL,
  update_cache = FALSE,
  verbose = FALSE,
  resolution = 10,
  ext = c("shp", "geojson", "svg", "json", "gdb"),
  recursive = deprecated(),
  ...
)
}
\arguments{
\item{id}{character string or number. Type of dataset to be
downloaded, see \strong{Details}. Values supported are:
\itemize{
\item \code{"countries"}
\item \code{"coastal_lines"}
\item \code{"communes"}
\item \code{"lau"}
\item \code{"nuts"}
\item \code{"urban_audit"}
\item \code{"postal_codes"}
}

This argument replaces the previous (deprecated) argument \code{id_giscoR}.}

\item{year}{character string or number. Release year of the file, see
\strong{Details}.}

\item{cache_dir}{character string. A path to a cache directory. See
\strong{Caching strategies} section in \code{\link[=gisco_set_cache_dir]{gisco_set_cache_dir()}}.}

\item{update_cache}{logical. Should the cached file be refreshed? Default
is \code{FALSE}. When set to \code{TRUE} it would force a new download.}

\item{verbose}{logical. If \code{TRUE} displays informational messages.}

\item{resolution}{character string or number. Resolution of the geospatial
data. One of:
\itemize{
\item \code{"60"}: 1:60 million.
\item \code{"20"}: 1:20 million.
\item \code{"10"}: 1:10 million.
\item \code{"03"}: 1:3 million.
\item \code{"01"}: 1:1 million.
}}

\item{ext}{Extension of the file(s) to be downloaded. Formats available are
\code{"shp"}, \code{"geojson"}, \code{"svg"}, \code{"json"}, \code{"gdb"}. See \strong{Details}.}

\item{recursive}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{recursive} is no
longer supported; this function will never perform recursive extraction of
child \code{.zip} files. This is the case of "\code{shp.zip} inside the top-level
\code{.zip}, that won't be unzipped.}

\item{...}{Ignored. The argument \code{id_giscoR}
(\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}) would be captured via \code{...} and
re-directed to \code{id} with a \link[lifecycle:deprecate_soft]{warning}.}
}
\value{
A (invisible) character vector with the full path of the files extracted.
See \strong{Examples}.
}
\description{
Download zipped data from GISCO to the \code{\link[=gisco_set_cache_dir]{cache_dir}}
and extract the relevant ones.
}
\details{
Some arguments only apply to a specific value of \code{"id"}. For example
\code{"resolution"} would be ignored for values \code{"communes"}, \code{"lau"},
\code{"urban_audit"} and \code{"postal_codes"}.

See years available in the corresponding functions:
\itemize{
\item \code{\link[=gisco_get_countries]{gisco_get_countries()}}.
\item \code{\link[=gisco_get_coastal_lines]{gisco_get_coastal_lines()}}.
\item \code{\link[=gisco_get_communes]{gisco_get_communes()}}.
\item \code{\link[=gisco_get_lau]{gisco_get_lau()}}.
\item \code{\link[=gisco_get_nuts]{gisco_get_nuts()}}.
\item \code{\link[=gisco_get_urban_audit]{gisco_get_urban_audit()}}.
\item \code{\link[=gisco_get_postal_codes]{gisco_get_postal_codes()}}.
}

The usual extensions used across \CRANpkg{giscoR} are \code{"gpkg"} and \code{"shp"},
however other formats are already available on GISCO. Note that after
performing a bulk download you may need to adjust the default \code{"ext"} value
in the corresponding function to connect it with the downloaded files (see
\strong{Examples}).
}
\examples{
\dontshow{if (gisco_check_access()) withAutoprint(\{ # examplesIf}
tmp <- file.path(tempdir(), "testexample")
\donttest{
dest_files <- gisco_bulk_download(
  id = "countries", resolution = 60,
  year = 2024, ext = "geojson",
  cache_dir = tmp
)
# Read one
library(sf)
read_sf(dest_files[1]) |> head()

# Now we can connect the function with the downloaded data like:

connect <- gisco_get_countries(
  resolution = 60,
  year = 2024, ext = "geojson",
  cache_dir = tmp, verbose = TRUE
)

# Message shows that file is already cached ;)
}
# Clean
unlink(tmp, force = TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
Additional utils for downloading datasets:
\code{\link{gisco_get_unit}}
}
\concept{extra}
