% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphon_generation.R
\name{sample_mixed_graph}
\alias{sample_mixed_graph}
\title{Generate a (U,W) mixture graph}
\usage{
sample_mixed_graph(W, wts, nd, ns, p = 0.5, option = 2)
}
\arguments{
\item{W}{The dense graphon. This is a symmetric matrix with values in [0,1]}

\item{wts}{The degree proportions of the hub degrees. Need to add up to 1. This
is the mass partition corresponding to the line graph graphon U.}

\item{nd}{The number of nodes in the dense part of the graph}

\item{ns}{The number of nodes in the sparse part of the graph}

\item{p}{The nodes to be added as a proportion of the edges in the dense part}

\item{option}{Graph joining option. If \code{option == 1} then a disjoit union is
considered. If \code{option == 2} the two graphs are joined randomly with the
number of edges specified by \code{p}.}
}
\value{
A graph sampled from the (U,W) mixture.
}
\description{
Generate a (U,W) mixture graph from a dense graphon W and a mass partition
corresponding to a line graph graphon U.
}
\examples{
library(igraph)
W <- matrix(0.1, nrow = 100, ncol = 100)
wts <- c(0.5, 0.3, 0.2)
ns <- 200
nd <- 100
p <- 0.5
gr <- sample_mixed_graph(W, wts, nd, ns, p, option = 2)
gr
}
