% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TwoSample.Estimator.GT.sequential.R
\name{TwoSample.Estimator.GT.sequential}
\alias{TwoSample.Estimator.GT.sequential}
\title{Function to calculate the two-sample generalized-t statistic for composite endpoint under sequential monitoring.}
\usage{
TwoSample.Estimator.GT.sequential(data, tau = 3)
}
\arguments{
\item{data}{A data frame generated by \code{TwoSample.generate.sequential()} (optionally after applying \code{Apply.calendar.censoring.2()})
containing simulated two-sample composite endpoint data.}

\item{tau}{Positive numeric value specifying the upper bound of event time for the integration. Default is \code{3}.}
}
\value{
A list with components:
\itemize{
\item \code{Q}: Value of the generalized t-test statistics integrated over \code{[0, tau]}.
\item \code{var}: Estimated asymptotic variance of \code{Q}.
\item \code{const}: Scaling constant used in the variance estimation.
}
}
\description{
Computes a two-sample generalized t-test statistic for composite endpoints consisting of recurrent events and
a terminal event, using data observed up to a given calendar time. Event times are converted from the calendar-time
scale to the event-time scale (time since enrollment).
}
\examples{
# Two-sample generalized-t statistic: null hypothesis
df <- TwoSample.generate.sequential(sizevec = c(200, 200),
beta.trt = 0, calendar = 5, recruitment = 3,
random.censor.rate = 0.05, seed = 2026)
TwoSample.Estimator.GT.sequential(data = df, tau = 3)
# Two-sample generalized-t statistic: alternative hypothesis
df2 <- TwoSample.generate.sequential(sizevec = c(200, 200),
beta.trt = 0.8, calendar = 5, recruitment = 3,
random.censor.rate = 0.05, seed = 2026)
TwoSample.Estimator.GT.sequential(data = df2, tau = 3)

}
