% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info_tables.R
\name{info_locales}
\alias{info_locales}
\title{View a table with info on supported locales}
\usage{
info_locales(begins_with = NULL)
}
\arguments{
\item{begins_with}{\emph{Show locales beginning with a specific letter}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

Providing a single letter will filter locales to only those that begin
with that letter in their locale ID. The default (\code{NULL}) will produce
a table with all locales displayed}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
Many of the \verb{fmt_*()} functions have a \code{locale} argument that makes
locale-based formatting easier. The table generated by the \code{info_locales()}
function provides a quick reference to all the available locales. The locale
identifiers are provided (base locale ID, common display name) along with the
each locale's group and decimal separator marks. A formatted numeric example
is provided (based on the value of \code{11027}) to demonstrate the default
formatting of each locale.
}
\details{
There are 574 locales, which means that a very long display
table is provided by default. To trim down the output table size, we can
provide an initial letter corresponding to the base locale ID to
\code{begins_with}. This will filter locales in the info table to just the set
that begins with the supplied letter.
}
\section{Examples}{


Get a table of info on all of the locales supported by \strong{gt}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{info_locales()
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_info_locales_1.png" alt="This image of a table was generated from the first code example in the `info_locales()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

11-4
}

\section{Function Introduced}{

\code{v0.2.0.5} (March 31, 2020)
}

\seealso{
Other information functions: 
\code{\link{info_currencies}()},
\code{\link{info_date_style}()},
\code{\link{info_flags}()},
\code{\link{info_google_fonts}()},
\code{\link{info_icons}()},
\code{\link{info_paletteer}()},
\code{\link{info_tf_style}()},
\code{\link{info_time_style}()},
\code{\link{info_unit_conversions}()}
}
\concept{information functions}
