% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/har_plot.R
\name{har_plot}
\alias{har_plot}
\title{Plot event detection on a time series}
\usage{
har_plot(
  obj,
  serie,
  detection = NULL,
  event = NULL,
  mark.cp = TRUE,
  ylim = NULL,
  idx = NULL,
  pointsize = 0.5,
  colors = c("green", "blue", "red", "purple"),
  yline = NULL
)
}
\arguments{
\item{obj}{A \code{harbinger} detector used to produce \code{detection}.}

\item{serie}{Numeric vector with the time series to plot.}

\item{detection}{Optional detection data.frame as returned by \code{detect()}.}

\item{event}{Optional logical vector with ground-truth events (same length as \code{serie}).}

\item{mark.cp}{Logical; if TRUE, marks detected change points with dashed vertical lines.}

\item{ylim}{Optional numeric vector of length 2 for y-axis limits.}

\item{idx}{Optional x-axis labels or indices (defaults to \code{seq_along(serie)}).}

\item{pointsize}{Base point size for observations.}

\item{colors}{Character vector of length 4 with colors for TP, FN, FP, and motif segments.}

\item{yline}{Optional numeric vector with y values to draw dotted horizontal lines.}
}
\value{
A \code{ggplot} object showing the time series with detected events highlighted.
}
\description{
Convenience plotting helper for Harbinger detections. It accepts a detector,
the input series, an optional detection data.frame, and optional ground-truth
events to color-code true positives (TP), false positives (FP), and false negatives (FN).
It can also mark detected change points and draw reference horizontal lines.
}
\examples{
library(daltoolbox)

# Load an example anomaly dataset
data(examples_anomalies)

# Use the simple time series
dataset <- examples_anomalies$simple
head(dataset)

# Set up an ARIMA-based anomaly detector
model <- hanr_arima()

# Fit the detector
model <- fit(model, dataset$serie)

# Run detection
detection <- detect(model, dataset$serie)

# Inspect detected events
print(detection[(detection$event),])

# Evaluate detections (soft evaluation)
evaluation <- evaluate(har_eval_soft(), detection$event, dataset$event)
print(evaluation$confMatrix)

# Plot the results
grf <- har_plot(model, dataset$serie, detection, dataset$event)
plot(grf)

}
\references{
\itemize{
\item Ogasawara, E., Salles, R., Porto, F., Pacitti, E. Event Detection in Time Series. 1st ed.
Cham: Springer Nature Switzerland, 2025. doi:10.1007/978-3-031-75941-3
}
}
