% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotcde.R
\name{plot.hdrcde}
\alias{plot.hdrcde}
\title{Plots highest density regions continuously over some conditioned variable.}
\usage{
\method{plot}{hdrcde}(
  x,
  plot.modes = TRUE,
  mden,
  threshold = 0.05,
  xlim,
  ylim,
  xlab,
  ylab,
  border = TRUE,
  font = 1,
  cex = 1,
  ...
)
}
\arguments{
\item{x}{Output from \code{\link[=hdr.cde]{hdr.cde()}}.}

\item{plot.modes}{Should modes be plotted as well as HDRs?}

\item{mden}{Marginal density in the \code{x} direction. When small, the HDRs
won't be plotted. Default is uniform so all HDRs are plotted.}

\item{threshold}{Threshold for margin density. HDRs are not plotted if the
margin density \code{mden} is lower than this value.}

\item{xlim}{Limits for x-axis.}

\item{ylim}{Limits for y-axis.}

\item{xlab}{Label for x-axis.}

\item{ylab}{Label for y-axis.}

\item{border}{Show border of polygons}

\item{font}{Font to be used in plot.}

\item{cex}{Size of characters.}

\item{\dots}{Other arguments passed to plotting functions.}
}
\value{
None.
}
\description{
Plots highest density regions continuously over some conditioned variable.
}
\examples{
faithful.cde <- cde(faithful$waiting, faithful$eruptions)
faithful.hdr <- hdr.cde(faithful.cde, prob = c(0.50, 0.95), plot = FALSE)
plot(faithful.hdr, xlab = "Waiting time", ylab = "Duration time")
}
\references{
Hyndman, R.J., Bashtannyk, D.M. and Grunwald, G.K. (1996)
"Estimating and visualizing conditional densities". \emph{Journal of
Computational and Graphical Statistics}, \strong{5}, 315-336.
}
\seealso{
\code{\link[=hdr.cde]{hdr.cde()}}, \code{\link[=cde]{cde()}},
}
\author{
Rob J Hyndman
}
\keyword{distribution}
\keyword{hplot}
\keyword{smooth}
