% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pulse_heart.R
\name{pulse_find_peaks_all_channels}
\alias{pulse_find_peaks_all_channels}
\title{Determine the heartbeat rate in all channels of a PULSE split window}
\usage{
pulse_find_peaks_all_channels(split_window)
}
\arguments{
\item{split_window}{one element of the \code{pulse_data_split} list() (which is the output from \code{\link[=pulse_split]{pulse_split()}}).}
}
\value{
A tibble with up to 10 rows (one for each channel) and 7 columns:
\itemize{
\item \code{id}, PULSE channel IDs
\item \code{time}, time at the center of split_window_one_channel$time
\item \code{data}, a list of tibbles with raw PULSE data for each combination of channel and window, with columns \code{time}, \code{val} and \code{peak} (\code{TRUE} when data points correspond to wave peaks)
\item \code{hz},  heartbeat rate estimate (in Hz)
\item \code{n},   number of wave peaks identified
\item \code{sd},  standard deviation of the intervals between wave peaks (normalized)
\item \code{ci},  confidence interval (hz ± ci)
}
}
\description{
Take data from PULSE data window and run \code{pulse_find_peaks_one_channel} in all channels.
}
\section{BPM}{

To convert to Beats Per Minute, simply multiply \code{hz} and \code{ci} by 60.
}

\examples{
## Begin prepare data ----
pulse_data_sub <- pulse_data
pulse_data_sub$data <- pulse_data_sub$data[,1:5]
pulse_data_split <- pulse_split(pulse_data_sub)
pulse_data_split <- pulse_optimize(pulse_data_split, multi = pulse_data$multi)
split_window <- pulse_data_split$data[[1]]
## End prepare data ----

# Determine heartbeat rates in all channels in one time window
pulse_find_peaks_all_channels(split_window)
}
\seealso{
\itemize{
\item \code{\link[=pulse_find_peaks_all_channels]{pulse_find_peaks_all_channels()}} runs \code{\link[=pulse_find_peaks_one_channel]{pulse_find_peaks_one_channel()}} on all PULSE channels
\item \code{\link[=pulse_read]{pulse_read()}}, \code{\link[=pulse_split]{pulse_split()}}, \code{\link[=pulse_optimize]{pulse_optimize()}}, \code{\link[=pulse_heart]{pulse_heart()}} and \code{\link[=pulse_choose_keep]{pulse_choose_keep()}} are the functions needed for the complete PULSE processing workflow
\item \code{\link[=PULSE]{PULSE()}} is a wrapper function that executes all the steps needed to process PULSE data at once
}
}
