% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.matrix.heckmanGE.R
\name{model.matrix.heckmanGE}
\alias{model.matrix.heckmanGE}
\title{model.matrix.heckmanGE
Get the Design Matrices of a Generalized Heckman Regression}
\usage{
\method{model.matrix}{heckmanGE}(
  object,
  part = c("selection", "outcome", "dispersion", "correlation"),
  ...
)
}
\arguments{
\item{object}{An object of class \code{heckmanGE}. This object should be a fitted model from which the design matrices will be extracted.}

\item{part}{A character vector specifying the model part for which to extract the design matrix. Options include "selection", "outcome", "dispersion", and "correlation". The default is "outcome". If multiple parts are specified, only the "outcome" part will be returned.}

\item{\dots}{Additional arguments passed to or from other methods. These are not used in this method but must be included to match the generic method signature.}
}
\value{
A design matrix for the specified part of the \code{heckmanGE} object. If \code{part} is not one of the valid options, an error is raised.
}
\description{
Extracts the design matrices for different parts of a \code{heckmanGE} model. The design matrices include the predictors used in the regression analysis for each component of the Generalized Heckman Model.
}
\details{
\itemize{
\item The function extracts the design matrix corresponding to the specified part of the \code{heckmanGE} model.
\item If the \code{part} argument is not specified correctly or includes multiple parts, the function defaults to returning the design matrix for the "outcome" part.
}
}
