% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_raster.R
\name{write_raster}
\alias{write_raster}
\title{Write hillshade to a file}
\usage{
write_raster(hillshade, elevation, filename, format, ...)
}
\arguments{
\item{hillshade}{A 2D matrix of shadow intensities.}

\item{elevation}{Original elevation raster.}

\item{filename}{Character.  Output filename.}

\item{format}{Character. Output file type. Passed to \code{raster::writeRaster}.}

\item{...}{Additional arguments passed to \code{raster::writeRaster}.}
}
\value{
This function is used for the side-effect of writing values to a file.
}
\description{
Write an array from a hillshade procedure to a geospatial raster file.
}
\examples{

library(rayshader)

out_fn <- paste0(tempfile(), ".tif")

# Create elevation matrix
el_mat <- maungawhau \%>\%
 raster_to_matrix()

 el_mat \%>\%
 # Create hillshade layer using
 # ray-tracing
 ray_shade() \%>\%
 # Add ambient shading
 add_shadow_2d(
   ambient_shade(
     heightmap = el_mat
   )
 ) \%>\%
 write_raster(
   elevation = maungawhau,
   filename = out_fn
 )

}
\author{
Pierre Roudier
}
