% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decomposition.R
\name{decomp}
\alias{decomp}
\alias{plot.inz_dcmp}
\title{Decompose a time series object}
\usage{
decomp(
  x,
  var = NULL,
  sm_model = c("stl"),
  mult_fit = FALSE,
  model_range = NULL,
  ...
)

\method{plot}{inz_dcmp}(
  x,
  recompose.progress = c(0, 0),
  recompose = any(recompose.progress > 0),
  ylab = NULL,
  title = NULL,
  colour = c("#1B9E46", "#45a8ff", "orangered"),
  ...
)
}
\arguments{
\item{x}{An `inz_dcmp` object representing the decomposed time series.}

\item{var}{A character vector of length one, or \code{NULL}.}

\item{sm_model}{The smoothing method to be used.
Currently on "stl" is available.}

\item{mult_fit}{If \code{TRUE}, a multiplicative model is used; otherwise,
an additive model is used by default.}

\item{model_range}{The range of data to be decomposed by the model. It can be
specified as dates or years. If part of \code{model_range} lies
outside the range of the data, the exceeding proportion is ignored.}

\item{...}{Additional arguments (ignored).}

\item{recompose.progress}{A numeric vector of length 2, controlling the
display of recomposition progress when `recompose` is `TRUE`.
The first component shows the progress for the seasonal component
(0 to 1), and the second component tracks the number of observations
recomposed so far.}

\item{recompose}{Logical indicating whether the recomposition should be
displayed or not.}

\item{ylab}{The label for the y-axis of the plot.}

\item{title}{The title for the plot.}

\item{colour}{A vector of three colors specifying the colors for the trend,
seasonal, and residuals components, respectively.}
}
\value{
An \code{inz_dcmp} object, which is a sub-class of \code{dable},
representing the decomposed components of the time series.
}
\description{
Decomposes a time series represented by an \code{inz_ts} object into its
seasonal, trend, and remainder components using the specified smoothing
method.
}
\examples{
ts <- inzightts(visitorsQ)
d <- decomp(ts)

\dontrun{
plot(d)
}

}
\references{
R. B. Cleveland, W. S. Cleveland, J.E. McRae, and I. Terpenning (1990)
STL: A Seasonal-Trend Decomposition Procedure Based on Loess.
Journal of Official Statistics, 6, 3iV73.
}
\seealso{
\code{\link[fabletools]{dable}}
}
