% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_helper_functions.R
\name{vol2C_lgdiatom}
\alias{vol2C_lgdiatom}
\title{Convert Biovolume to Carbon for Large Diatoms}
\usage{
vol2C_lgdiatom(volume)
}
\arguments{
\item{volume}{A numeric vector of biovolume measurements in microns^3.}
}
\value{
A numeric vector of carbon measurements in picograms.
}
\description{
This function converts biovolume in microns^3 to carbon in picograms
for large diatoms (> 2000 micron^3) according to Menden-Deuer and Lessard 2000.
The formula used is: log pgC cell^-1 = log a + b * log V (um^3),
with log a = -0.933 and b = 0.881 for diatoms > 3000 um^3.
}
\examples{
# Volumes in microns^3
volume <- c(5000, 10000, 20000)

# Convert biovolume to carbon for large diatoms
vol2C_lgdiatom(volume)
}
