% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitit.R
\name{fitit}
\alias{fitit}
\title{Fit proportional hazard model with smooth baseline hazard and (optional) interval censoring}
\usage{
fitit(
  Y,
  R,
  dead,
  X,
  B,
  Ic,
  R1,
  cbx,
  Pdiff,
  Pridge,
  lambda,
  nit = 50,
  tol = 1e-06,
  tollam = 0.01,
  update_lambda = FALSE,
  ic_update = TRUE,
  monitor = FALSE
)
}
\arguments{
\item{Y}{Events (matrix, number of bins by subjects)}

\item{R}{Risk sets (matrix, number of bins by subjects)}

\item{dead}{(Boolean vector, TRUE if event, FALSE if right censored)}

\item{X}{Covariates (matrix, number of covariates (+1) by subjects)}

\item{B}{B-spline basis matrix}

\item{Ic}{Censoring interval per individual, coded as 0/1 (in columns)}

\item{R1}{Left truncation interval per individual, coded as 0/1 (in columns)}

\item{cbx}{Vector of starting values}

\item{Pdiff}{B-spline part of penalty matrix}

\item{Pridge}{Ridge part of penalty matrix (for intercept)}

\item{lambda}{Smoothing parameter (number)}

\item{nit}{Maximum number of iterations (integer)}

\item{tol}{Tolerance for final fit}

\item{tollam}{Tolerance for switching to lambda update}

\item{update_lambda}{Automatic update of lambda (Boolean)}

\item{ic_update}{Update risk and event probabilities (Boolean)}

\item{monitor}{Monitor convergence (Boolean)}
}
\value{
A list with items
\item{cbx}{Vector of }
\item{ll}{Poisson GLM log-likelihood}
\item{lambda}{Final tuning parameter}
\item{pen}{Penalty part of penalized log-likelihood}
\item{ed}{Effetive dimension of the baseline hazard}
\item{nit1}{Number of iterations used in first phase}
\item{nit}{Total number of iterations used (first plus second phase)}
\item{tollam}{Tolerance used for switching to lambda update}
}
\description{
Fit proportional hazard model with smooth baseline hazard and (optional) interval censoring
}
