% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v0_vis.R
\name{vis.immunr_gene_usage}
\alias{vis.immunr_gene_usage}
\title{Histograms and boxplots (general case / gene usage)}
\usage{
\method{vis}{immunr_gene_usage}(.data, .plot = c("hist", "box", "heatmap", "heatmap2", "circos"), ...)
}
\arguments{
\item{.data}{Output from the \link{geneUsage} function.}

\item{.plot}{String specifying the plot type:
\itemize{
\item "hist" for histograms using \link{vis_hist};
\item "heatmap" for heatmaps using \link{vis_heatmap};
\item "heatmap2" for heatmaps using \link{vis_heatmap2};
\item "circos" for circos plots using \link{vis_circos}.
}}

\item{...}{Other arguments passed to corresponding functions depending on the plot type:
\itemize{
\item "hist" - passes arguments to \link{vis_hist};
\item "box" - passes arguments to \link{vis_box};
\item "heatmap" - passes arguments to \link{vis_heatmap};
\item "heatmap2" - passes arguments to \link{vis_heatmap2} and \link{heatmap} from the "pheatmap" package;
\item "circos" - passes arguments to \link{vis_circos} and \link[circlize:chordDiagram]{circlize::chordDiagram} from the "circlize" package.
}}
}
\value{
A ggplot2 object, pheatmap or circlize object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Visualise distributions of genes using heatmaps or other plots.
}
\examples{
\dontrun{
data(immdata)

gu <- geneUsage(immdata$data[[1]])
vis(gu)

gu <- geneUsage(immdata$data)
vis(gu, .by = "Status", .meta = immdata$meta)
vis(gu, "box", .by = "Status", .meta = immdata$meta)
}
}
\seealso{
\link{geneUsage}
}
\concept{gene_usage}
