% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.R
\name{get_pca_predictions}
\alias{get_pca_predictions}
\title{Return PCA predictions.}
\usage{
get_pca_predictions(
  x,
  pca.term = NULL,
  weights = NULL,
  view = NULL,
  cond = list(),
  select = NULL,
  n.grid = 30,
  se = 1.96,
  xlim = NULL,
  ylim = NULL,
  partial = TRUE,
  rm.ranef = NULL,
  as.data.frame = TRUE,
  print.summary = getOption("itsadug_print")
)
}
\arguments{
\item{x}{A gam object, produced by \code{\link[mgcv]{gam}} or 
\code{\link[mgcv]{bam}}.}

\item{pca.term}{Text string, name of model predictor that represents a 
principle component.}

\item{weights}{Named list with the predictors that are combined in the PC 
and their weights. See examples.}

\item{view}{A two-value vector containing the names of the two terms to 
plot. The two terms should be part of the PC. Note that 
variables coerced to factors in the model formula won't work as view 
variables.}

\item{cond}{A named list of the values to use for the other predictor 
terms (not in view). Used for choosing between smooths that share the 
same view predictors.}

\item{select}{A number, selecting a single model term for printing. e.g. 
if you want the plot for the second smooth term set select=2.}

\item{n.grid}{The number of grid nodes in each direction used for 
calculating the plotted surface.}

\item{se}{If less than or equal to zero then only the predicted surface 
is plotted, but if greater than zero, then 3 surfaces are plotted, one at 
the predicted values minus se standard errors, one at the predicted 
values and one at the predicted values plus se standard errors.}

\item{xlim}{A two item array giving the lower and upper limits for the x-
axis scale. NULL to choose automatically.}

\item{ylim}{A two item array giving the lower and upper limits for the y-
axis scale. NULL to choose automatically.}

\item{partial}{Logical value: whether or not to plot the partial effect 
(TRUE) or the summed effect (FALSE, default).}

\item{rm.ranef}{Logical: whether or not to remove random effects. 
Default is TRUE.}

\item{as.data.frame}{Logical: whether the output is returned as data 
frame (TRUE, default) or as list (FALSE).}

\item{print.summary}{Logical: whether or not to print a summary.
Default set to the print info messages option 
(see \code{\link{infoMessages}}).}
}
\description{
Produces perspective or contour plot views of gam model 
predictions of the additive effects interactions.
The code is based on the script for \code{\link[mgcv]{vis.gam}}, 
but allows to cancel random effects.
}
\examples{
data(simdat)
# add hypothetical correlated term:
simdat$predictor <-  (simdat$Trial+10)^.75 + rnorm(nrow(simdat))
# principal components analysis:
pca <- prcomp(simdat[, c('Trial', 'predictor')])
# only first PC term contributes:
summary(pca)
# get rotation (weights of predictors in PC):
pcar <- pca$rotation
# add PC1 to data:
simdat$PC1 <- pca$x[,1]

\dontrun{
# model:
m1 <- bam(Y ~ Group + te(Time, PC1, by=Group) 
    + s(Time, Subject, bs='fs', m=1, k=5), data=simdat)
# inspect surface:
fvisgam(m1, view=c('Time', 'PC1'), cond=list(Group='Children'),
    rm.ranef=TRUE)
# how does Trial contribute?
p <- get_pca_predictions(m1, pca.term='PC1', weights=pcar[,'PC1'], 
    view=c('Time', 'Trial'), cond=list(Group='Children'),
    rm.ranef=TRUE, partial=FALSE)
# Note that the range of Trial is estimated based on the values of PC1.
# A better solution is to specify the range:
p <- get_pca_predictions(m1, pca.term='PC1', weights=pcar[,'PC1'], 
    view=list(Time=range(simdat$Time), Trial=range(simdat$Trial)), 
    cond=list(Group='Children'),rm.ranef=TRUE, partial=FALSE)
# plotting of the surface:
plot_pca_surface(m1, pca.term='PC1', weights=pcar[,'PC1'], 
    view=c('Time', 'Trial'), cond=list(Group='Children'),rm.ranef=TRUE)
}
}
\seealso{
\code{plot_pca_surface}, \code{\link[stats]{prcomp}}

Other Functions for PCA interpretation: 
\code{\link{plot_pca_surface}()}
}
\author{
Jacolien van Rij
}
\concept{Functions for PCA interpretation}
