% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynPred.R
\name{dynPred}
\alias{dynPred}
\title{Dynamic Prediction of Transition Probabilities}
\usage{
dynPred(object, patient_id, landmark = 0, horizon = 3, n_points = 60)
}
\arguments{
\item{object}{A \code{"jmSurface"} object from \code{jmSurf}.}

\item{patient_id}{Integer patient identifier.}

\item{landmark}{Numeric landmark time (predict from this time).}

\item{horizon}{Numeric prediction horizon (predict this many years ahead).}

\item{n_points}{Integer number of time points for the prediction grid.
Default \code{60}.}
}
\value{
Data frame with columns:
\item{time}{Absolute time points}
\item{risk}{Cumulative transition probability}
\item{hazard}{Instantaneous hazard at each time point}
\item{transition}{Transition name}
\item{to_state}{Target state}
\item{patient_id}{Patient identifier}
\item{landmark}{Landmark time used}
}
\description{
Computes personalized dynamic predictions of transition probabilities
from a fitted \code{jmSurface} model. Given a patient's biomarker
history up to a landmark time, projects the latent trajectories forward
and integrates the transition-specific hazard to obtain cumulative
transition probabilities.
}
\details{
The conditional transition probability is computed as:
\deqn{\pi_i^{rs}(t_L, \Delta t) = 1 - \exp\left\{-\int_{t_L}^{t_L+\Delta t} \lambda_i^{rs}(u | \hat\eta_i(u)) du\right\}}
where \eqn{\hat\eta_i(u)} is the BLUP-projected trajectory and the integral
is approximated via the Breslow estimator.
}
