% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/longitudinal.R
\name{fit_longitudinal}
\alias{fit_longitudinal}
\title{Fit Longitudinal Mixed-Effects Models for Each Biomarker}
\usage{
fit_longitudinal(long_data, markers = NULL, verbose = TRUE)
}
\arguments{
\item{long_data}{Data frame with columns \code{patient_id},
\code{visit_time_years}, \code{biomarker}, \code{value}.}

\item{markers}{Character vector of biomarker names to fit. If \code{NULL},
all unique biomarkers in \code{long_data} are used.}

\item{verbose}{Logical; print progress. Default \code{TRUE}.}
}
\value{
Named list of \code{nlme::lme} objects, one per biomarker.
Failed fits are \code{NULL}.
}
\description{
Stage 1 of the two-stage estimation: fits a random intercept-slope model
\eqn{y_{ij}(t) = (\beta_{0j} + b_{0ij}) + (\beta_{1j} + b_{1ij})t + \epsilon_{ij}(t)}
for each biomarker using \code{nlme::lme}.
}
