% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/torch_nn_exec.R
\name{ffnn}
\alias{ffnn}
\alias{rnn}
\title{Base models for Neural Network Training in kindling}
\usage{
ffnn(
  formula,
  data,
  hidden_neurons,
  activations = NULL,
  output_activation = NULL,
  bias = TRUE,
  epochs = 100,
  batch_size = 32,
  learn_rate = 0.001,
  optimizer = "adam",
  loss = "mse",
  validation_split = 0,
  device = NULL,
  verbose = FALSE,
  cache_weights = FALSE,
  ...
)

rnn(
  formula,
  data,
  hidden_neurons,
  rnn_type = "lstm",
  activations = NULL,
  output_activation = NULL,
  bias = TRUE,
  bidirectional = TRUE,
  dropout = 0,
  epochs = 100,
  batch_size = 32,
  learn_rate = 0.001,
  optimizer = "adam",
  loss = "mse",
  validation_split = 0,
  device = NULL,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{formula}{Formula. Model formula (e.g., y ~ x1 + x2).}

\item{data}{Data frame. Training data.}

\item{hidden_neurons}{Integer vector. Number of neurons in each hidden layer.}

\item{activations}{Activation function specifications. See \code{act_funs()}.}

\item{output_activation}{Optional. Activation for output layer.}

\item{bias}{Logical. Use bias weights. Default \code{TRUE}.}

\item{epochs}{Integer. Number of training epochs. Default \code{100}.}

\item{batch_size}{Integer. Batch size for training. Default \code{32}.}

\item{learn_rate}{Numeric. Learning rate for optimizer. Default \code{0.001}.}

\item{optimizer}{Character. Optimizer type ("adam", "sgd", "rmsprop"). Default \code{"adam"}.}

\item{loss}{Character. Loss function ("mse", "mae", "cross_entropy", "bce"). Default \code{"mse"}.}

\item{validation_split}{Numeric. Proportion of data for validation (0-1). Default \code{0}.}

\item{device}{Character. Device to use ("cpu", "cuda", "mps"). Default \code{NULL} (auto-detect).}

\item{verbose}{Logical. Print training progress. Default \code{FALSE}.}

\item{cache_weights}{Logical. Cache weight matrices for faster variable importance
computation. Default \code{FALSE}. When \code{TRUE}, weight matrices are extracted and
stored in the returned object, avoiding repeated extraction during importance
calculations. Only enable if you plan to compute variable importance multiple times.}

\item{...}{Additional arguments passed to the optimizer.}

\item{rnn_type}{Character. Type of RNN ("rnn", "lstm", "gru"). Default \code{"lstm"}.}

\item{bidirectional}{Logical. Use bidirectional RNN. Default \code{TRUE}.}

\item{dropout}{Numeric. Dropout rate between layers. Default \code{0}.}
}
\value{
An object of class "ffnn_fit" containing:
\item{model}{Trained torch module}
\item{formula}{Model formula}
\item{fitted.values}{Fitted values on training data}
\item{loss_history}{Training loss per epoch}
\item{val_loss_history}{Validation loss per epoch (if validation_split > 0)}
\item{n_epochs}{Number of epochs trained}
\item{feature_names}{Names of predictor variables}
\item{response_name}{Name of response variable}
\item{device}{Device used for training}
\item{cached_weights}{Weight matrices (only if cache_weights = TRUE)}
}
\description{
Base models for Neural Network Training in kindling
}
\section{FFNN}{

Train a feed-forward neural network using the torch package.
}

\section{RNN}{

Train a recurrent neural network using the torch package.
}

\examples{
\donttest{
if (torch::torch_is_installed()) {
    # Regression task (auto-detect GPU)
    model_reg = ffnn(
        Sepal.Length ~ .,
        data = iris[, 1:4],
        hidden_neurons = c(64, 32),
        activations = "relu",
        epochs = 50,
        verbose = FALSE
    )

    # With weight caching for multiple importance calculations
    model_cached = ffnn(
        Species ~ .,
        data = iris,
        hidden_neurons = c(128, 64, 32),
        activations = "relu",
        cache_weights = TRUE,
        epochs = 100
    )
} else {
    message("Torch not fully installed — skipping example")
}

}

\donttest{
# Regression with LSTM on GPU
if (torch::torch_is_installed()) {
    model_rnn = rnn(
        Sepal.Length ~ .,
        data = iris[, 1:4],
        hidden_neurons = c(64, 32),
        rnn_type = "lstm",
        activations = "relu",
        epochs = 50
    )

    # With weight caching
    model_cached = rnn(
        Species ~ .,
        data = iris,
        hidden_neurons = c(128, 64),
        rnn_type = "gru",
        cache_weights = TRUE,
        epochs = 100
    )
} else {
    message("Torch not fully installed — skipping example")
}
}

}
