% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kld-analytical.R
\name{kld_exponential}
\alias{kld_exponential}
\title{Analytical KL divergence for two univariate exponential distributions}
\usage{
kld_exponential(lambda1, lambda2)
}
\arguments{
\item{lambda1}{A scalar (rate parameter of true exponential distribution)}

\item{lambda2}{A scalar (rate parameter of approximate exponential distribution)}
}
\value{
A scalar (the Kullback-Leibler divergence)
}
\description{
This function computes \eqn{D_{KL}(p||q)}, where \eqn{p\sim \text{Exp}(\lambda_1)}
and \eqn{q\sim \text{Exp}(\lambda_2)}, in rate parametrization.
}
\examples{
kld_exponential(lambda1 = 1, lambda2 = 2)
}
