% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Geometric.R
\name{likgeom}
\alias{likgeom}
\title{Geometric Log Likelihood Function}
\usage{
likgeom(x, prob, log = TRUE)
}
\arguments{
\item{x}{vector of quantiles representing the number of failures in
    a sequence of Bernoulli trials before success occurs.}

\item{prob}{probability of success in each trial. \code{0 < prob <= 1}.}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}
}
\value{
A numeric scalar for the log likelihood of the geometric density
given the data where prob can be held constant or if vector were given
vector will be returned.
}
\description{
The log likelihood of a geometric density with data, x, prob parameter.
}
\details{
The log likelihood is the log of a function of parameters given the data.
}
\examples{
likgeom(x = rgeom(n = 2, prob = .4),
        prob = .4)
}
