% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Multinomial.R
\name{likmultinom}
\alias{likmultinom}
\title{Multinomial Log Likelihood Function}
\usage{
likmultinom(x, size = NULL, prob, log = TRUE)
}
\arguments{
\item{x}{vector of length \eqn{K} of integers in \code{0:size}.}

\item{size}{integer, say \eqn{N}, specifying the total number
    of objects that are put into \eqn{K} boxes in the typical multinomial
    experiment. For \code{dmultinom}, it defaults to \code{sum(x)}.}

\item{prob}{numeric non-negative vector of length \eqn{K}, specifying
    the probability for the \eqn{K} classes; is internally normalized to
    sum 1. Infinite and missing values are not allowed.}

\item{log}{logical; if TRUE, log probabilities are computed.}
}
\value{
A numeric scalar for the log likelihood of the multinomial density
given the data where size and prob can be held constant or if vector were
given vector will be returned.
}
\description{
The log likelihood of a multinomial density with data, x, size and prob
parameters.
}
\details{
The log likelihood is the log of a function of parameters given the data.
}
\examples{
likmultinom(x = rmultinom(n = 2, size = 3, prob = .4),
        size = 3, prob = .4)
}
